const int Baudrate = 19200;
const int Analog_Input_Pin = 0;

void setup()
{
  Serial.begin(Baudrate); // For sending data to the computer over USB
  cli(); // disable interrupts while changing settings
  TCCR1A = 0x00; // clear default timer settings
  TCCR1B = 0x00; // timer in normal mode
  TCCR1B |= (1 << WGM12); // Configure timer 1 for CTC mode
  TCCR1B |= (0 << CS12); // Set timer prescaling by setting 3 bits
  TCCR1B |= (1 << CS11); // 001=1, 010=8, 011=64, 100=256, 101=1024
  TCCR1B |= (1 << CS10);
  TIMSK1 |= (1 << OCIE1A); // Enable CTC interrupt with OCF1A flag in TIFR1
  OCR1A = 124; // Set CTC compare value: 500Hz for fI/O = 8MHz
  sei(); // turn interrupts back on
}
void loop() {
  // nothing to do, its all in the interrupt handlers!
}

ISR(TIMER1_COMPA_vect) // when timer counts down it fires this interrupt
{
  int val = analogRead(Analog_Input_Pin);
  Serial.write(val >> 2);
}
